import pandas as pd
import openpyxl
import matplotlib.pyplot as plt
import seaborn as sns

plt.rcParams['font.family'] = 'WebSubsetFont' # 日本語フォント

# EXCELファイル読み込み
df = pd.read_excel('成績.xlsx')

#箱ひげ
plt.clf() # 前回描画のクリア
sns.catplot(y='数学', data=df, kind='box', hue='クラス')
display(plt,target="A-箱ひげ")

#ヒストグラフ
plt.clf() # 前回描画のクリア
sns.displot(x="数学",data=df,stat="density", hue="クラス",multiple="stack")
display(plt,target="B-ヒストグラフフ")

#散布図
plt.clf() # 前回描画のクリア
sns.scatterplot(x='数学', y='理科', data=df,hue='クラス')
display(plt,target="D-散布図")

#散布図行列
plt.clf() # 前回描画のクリア
sns.pairplot(df,vars=["数学","国語","理科"],hue='クラス')
display(plt,target="E-散布図行列")



