/*
    JavaScriptでゲーム 1.0
    作成日：2020.11.30
    Copyright © 2020 佐古田 堅二郎 All rights reserved.
    修正履歴：
                2020/11/30:戦闘機と敵機が衝突した時のスコアー異常修正

*/


var canvas = 0;
var ctx =  0;
var controller =  0;
var ctx2 =  0;
var my =  0;
var teki =  0;
var mikata =  0;
var bakuha =  0;

var my_x = 1;           //自機横位置
var my_houkou=0;        //自機移動値
var my_x_size=0;         //自機横サイズ
var my_y_size=0;        //自機縦サイズ
var my_die = false;
var my_bakuhatu_count=0;   //戦闘機爆発シーンカウント

var bullet=Array(BULLET_KAZU);  //弾丸用変数
var bullet_flg = false;         //発射フラグ
var bullet_count = BAKUHA_INTER; //発射間隔カウンター
var bullet_kazu = BULLET_KAZU;  //残り弾丸


var teki_x_size = 0; //敵機横サイズ
var teki_y_size = 0;//敵機縦サイズ
var te=Array(TEKI_KAZU);    //敵機用変数
var teki_count = TEKI_INTER;//出撃間隔カウンター
var teki_fight_su = TEKI_FIGHT_SU;//1回の出撃数
var teki_speed = TEKI_SPEED;     //敵機スピード

var bakuha_width_teki = 0;
var bakuha_height_teki = 0;
var bakuha_widht_my = 0;
var bakuha_height_my =0;

var start_time=0;         //開始時間

var game_status = GAME_START; //ゲーム状態
var final_count = 0;          //終了アニメーションカウンター
var final_time = 0;           //最終経過時間


var interval = 0;             //一定間隔呼び出し戻り値

var scores=[];      //スコアー用

var hiritu = 0;     //画面拡大比率
window.onload = function() {
    canvas = document.getElementById("canvas");
    ctx = canvas.getContext("2d");
    controller = document.getElementById("controller");
    ctx2 = controller.getContext("2d");
    my = document.getElementById("my");
    teki = document.getElementById("teki");
    mikata = document.getElementById("mikata");
    bakuha = document.getElementById("bakuha");
    my_x_size=my.width/MY_SHRINK;         //自機横サイズ
    my_y_size=my.height/MY_SHRINK;        //自機縦サイズ
    teki_x_size = teki.width/TEKI_SHRINK; //敵機横サイズ
    teki_y_size = teki.height/TEKI_SHRINK;//敵機縦サイズ
    bakuha_width_teki = (teki_x_size - bakuha.width/3)/2;
    bakuha_height_teki =(teki_y_size - bakuha.height)/2;
    bakuha_widht_my = (my_x_size - (bakuha.width/3)*BAKUHA_BAI)/2;
    bakuha_height_my =(my_y_size - bakuha.height*BAKUHA_BAI)/2;
/*
    scores[0] = 100;
    scores[1] = 99;
    scores[2] = 98;
    setScore(99);
    console.log(scores);
*/    
    setDispSize();      //画面サイズ変更
    drawController();   //コントローラー描画
    init();             //初期処理
    draw();             //描画処理

};       


    /*
      描画処理
    */
    function draw(){
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        if(game_status == GAME_FINAL){
          drawFinal();
        }
        if(game_status==GAME_START){
          drawStart();  //ゲーム開始描画
        }else{
          myMove();     //自機を描画
        }
        bulletMove(); //弾丸描画
        tekiMove();   //敵機描画
        infoDisp();   //情報表示
    }



    
    /*
      コントローラ描画
    */
    function drawController(){
        ctx2.strokeStyle = COLOR_CONTROLLER_WAKU; //外枠
        ctx2.lineWidth = 3;
        ctx2.strokeRect(L_S,0,R_E-L_S,controller.height);


        ctx2.beginPath();             //右三角形
        ctx2.moveTo( L_S,controller.height/2 ) ;
        ctx2.lineTo( L_E,0 )
        ctx2.lineTo( L_E,controller.height  )
        ctx2.fillStyle = COLOR_CONTROLLER_HOUKOU;
        ctx2.fill() ;
        ctx2.closePath();

        ctx2.beginPath();             //左三角形
        ctx2.moveTo( R_E,controller.height/2 ) ;
        ctx2.lineTo( R_S,0 )
        ctx2.lineTo( R_S,controller.height  )
        ctx2.fillStyle = COLOR_CONTROLLER_HOUKOU;
        ctx2.fill() ;
        ctx2.closePath();

        ctx2.beginPath();             //発射丸ボタン
        ctx2.arc(controller.width/2, controller.height/2, controller.height/2-1, 0, Math.PI*2, false);
        ctx2.fillStyle = COLOR_CONTROLLER_SHOT;
        ctx2.fill();
        ctx2.closePath();

        ctx2.fillStyle = COLOR_CONTROLLER_GRAY;//発射ボタンと方向(三角)のグレーゾーン
        ctx2.lineWidth = 1;
        ctx2.fillRect(M_S,0,M_E-M_S,controller.height);

    }



    /*
      初期処理
    */
    function init(){
        document.addEventListener("keydown", keyDown);
        document.addEventListener("keyup", keyUp);
        document.addEventListener('mousedown',mouseDown);
        document.addEventListener('mouseup',stop);
        document.addEventListener('touchstart',touchStart);
        document.addEventListener('touchend',stop);

        teki_fight_su = TEKI_FIGHT_SU;//1回の出撃数
        teki_speed = TEKI_SPEED;     //敵機スピード
        bullet_kazu = BULLET_KAZU;  //残り弾丸
        teki_count = TEKI_INTER;//出撃間隔カウンター
        my_die = false;         //自機生死
        my_x = 1;           //自機横位置


        for(let i = 0; i < bullet.length; i++) { //弾丸管理変数初期化
            bullet[i] = [0,0,0];
        }

        for(let i = 0; i < te.length; i++) { //敵機管理変数初期化
            te[i] = [0,0,0,0,0];
        }
        getScore();     //スコアー取得

    }
    /*
      Canvasサイズ変更
    */
    function setDispSize(){
      var area = document.getElementById("area"); //現在表示サイズを求める
      var x = document.documentElement.clientWidth;
      var y = document.documentElement.clientHeight;
      //実際の表示画面の横、縦小さい方を基準に拡大する
      if(x > y){  //縦が小さい 縦基準
        var y2 = y * (1-AREA_MARGIN);//余白分引く
        hiritu = y2 / area.clientHeight;  //拡大比率

      }else{
        var x2 = x * ( 1-AREA_MARGIN);//余白分引く
        hiritu = x2 / area.clientWidth;  //拡大比率
      }
      canvas.style.width = String(canvas.width * hiritu)+"px";  //ゲームcanvas拡大
      canvas.style.height = String(canvas.height * hiritu)+"px";
      controller.style.width = String(canvas.width * hiritu)+"px";//パッドcanvas拡大
      controller.style.height = String(controller.height * hiritu)+"px";

    }
