     /*
      敵機との衝突判定
        引数： x・・・横座標、y・・・縦座標
        　　　lx・・・横幅、ly・・・縦幅
        戻り値:  
                COLLISION_NOTHING　     衝突無し
                COLLISION_ANYTHING以上  衝突有り
                                        配列インデクスが戻る

    */
   function colliTeki(x,y,lx,ly){
    for(var i=0;i<te.length;i++){//出撃中の敵機を探す
      if(te[i][0]==TEKI_FIGHT_TEKI || te[i][0]==TEKI_FIGHT_MIKATA ){
        if(collision(te[i][2],te[i][3],teki_x_size,teki_y_size,
                     x,y,lx,ly)){
            return i; //衝突した配列インデックスを返す
        }
      }
    }
    return COLLISION_NOTHING;
  }
 /*
    敵機同士の衝突確認
      引数：   
              j　判定機の配列インデックス
      戻り値:  
              COLLISION_NOTHING　     衝突無し
              COLLISION_ANYTHING以上  衝突有り
                                      配列インデクスが戻る
   */
   function colliTekivsTeki(j){
    for(var i=0;i<te.length;i++){//出撃中の敵機を探す
      if( i==j){  //同じ機なら判定しない
        continue;
      }
      if(te[i][0]==TEKI_FIGHT_TEKI || te[i][0] ==TEKI_FIGHT_MIKATA){
        if(collision(te[i][2],te[i][3],teki_x_size,teki_y_size,
                     te[j][2],te[j][3],teki_x_size,teki_y_size)){
              return i; //衝突した配列インデックスを戻す
        }
      }
    }
    return COLLISION_NOTHING;
  }

  /*
    衝突共通判断　四角形＆四角形の衝突判定
  */
  function collision(x1,y1,lx1,ly1,x2,y2,lx2,ly2){
    if( ((x1-lx2)<= x2) && (x2 <= (x1+lx1)) &&
     ((y1-ly2)<= y2) && (y2 <= (y1+ly1)) ){
       return true;
     }
     return false;
   }
